require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);
SetGamePause(true);

kOffX=50;

function IntroPicture(val)
    t = {};
    if (val==1) then
        table.insert(t, Bitmap
            {
                image=GetIntroPictureName(),
                x=kCenter+kOffX+GetIntroPictureOffX(),
                y=kCenter+GetIntroPictureOffY(),
            })
    end
    return Group(t);
end

MakeDialog
{
    CDPanelStart
    {
        name="panelstart",
        x = 0,
        y = 0,
        w = 800,
        h = 600,
        
        enter_curve = "config/curves/fx_start.xml",
        exit_curve = "config/curves/fx_end.xml",
        
        wink_x = 221,
        wink_y = 160,
        
        Bitmap
        {
            name="panel",
            image="ui/levelintro/levelintro",
            x=kCenter,
            y=kCenter - 1000,
            

            SetStyle(CreateTextStyle(FontGame, 36, RedColor)),
            CreateText(kCenter - 65, kCenter-235, "#"..GetString("level",GetCurrLevelNumStr()), 0, 0),

            SetStyle(CreateTextStyle(FontGame, 20, BlackColor)),
            Text
            {
                x=kCenter +35,-- + 25,
                y=100,
                w = 240,--kMax - 122,
                h = kMax,
                label=GetString("story_intro",GetCurrLevelNumStr()),
                flags = kVAlignTop + kHAlignLeft,
            },

            SetStyle(CreateTextStyle(FontGame, 24, BlackColor)),
            CreateText(kCenter+30, kCenter+116, "#"..GetString("goal",GetLevelGoalStr()), 0, 0),
            
            SetStyle(CreateTextStyle(FontGame, 24, BlackColor)),
            CreateText(kCenter+30, kCenter+140, "#"..GetString("expert",GetLevelExpertStr()), 0, 0),

            IntroPicture(IsIntroPictureRequired()),

            SetStyle({});

            Bitmap
            {
                image = "ui/buttons/buttonup",
                x=kCenter+30,
                y=kCenter + 185,
                
                SetStyle(CreateTextStyle(FontButtons, 22, GrayColor)),
                CreateText(0,0,"start",0,0),
                    
                SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
                Button
                {
                    x=kCenter,
                    y=kCenter,
                    name="start",
                    default = true,
                    command=
                        function()
                            HideStartPanel();
                        end,
				    SetStyle(CreateTextStyle(FontButtons, 32, WhiteColorAlpha128)),
				    CreateText(2,2,"start", 0, 0),
				    SetStyle(CreateTextStyle(FontButtons, 32, BlackColor)),
				    CreateText(0,0,"start", 0, 0),
                },
            },
        },
    }
}